import { LootType } from "core/types/CommunityService";
import { name } from "./constants";
import { containsSumoExperiment } from "./helpers";

export function selectCommunityService(state) {
  return state[name];
}

export function selectIsPrime(state) {
  const stateName = state[name];
  const user = !!stateName && stateName.user;
  return !!user && !!user.hasPrime;
}

export function selectHasCredit(state) {
  const stateName = state[name];
  const user = !!stateName && stateName.user;
  const credit = !!user && user.credit;
  return !!credit && credit.balance >= 1;
}

export function selectHasIdentitySharingEnabled(state) {
  const stateName = state[name];
  return !!stateName && !!stateName.hasIdentitySharingEnabled;
}

export function selectOfferID(state) {
  const stateName = state[name];
  const loot = stateName && stateName.loot;
  const offerID = loot && loot.contentId;
  return offerID || "";
}

export function selectContentMessage(state) {
  const stateName = state[name];
  const loot = stateName && stateName.loot;
  const message = loot && loot.message;
  return message || "";
}

export function selectContentImage(state) {
  const stateName = state[name];
  const loot = stateName && stateName.loot;
  const imageUrl = loot && loot.imageUrl;
  return imageUrl || "";
}

export function selectSubscribed(state) {
  const stateName = state[name];
  const user = !!stateName && stateName.user;
  const credit = !!user && user.credit;
  return !!credit && !!credit.subscribed;
}

export function selectType(state) {
  const stateName = state[name];
  const loot = stateName && stateName.loot;
  const type = loot && loot.type;
  return type || LootType.LOOT;
}

export function selectSignUpLink(state) {
  const stateName = state[name];
  const signup = stateName && stateName.signup;
  return !!signup && signup.destinationLink;
}

export function selectOfferLink(state) {
  const stateName = state[name];
  const loot = stateName && stateName.loot;
  return !!loot && loot.destinationLink;
}

export function selectSubscribedTime(state) {
  const stateName = state[name];
  const user = !!stateName && stateName.user;
  const lastSpend = !!user && user.lastSpend;
  return !!lastSpend && lastSpend.timestamp;
}

export function selectSubscribedChannel(state) {
  const stateName = state[name];
  const user = !!stateName && stateName.user;
  const lastSpend = !!user && user.lastSpend;
  return !!lastSpend && lastSpend.channel;
}

export function selectLocation(state) {
  const stateName = state[name];
  return !!stateName && stateName.location;
}

export function selectIsWhiteListedForSumo(state) {
  const stateName = state[name];
  return stateName && containsSumoExperiment(stateName.experiments);
}