/**
 * DisplayModule reducer.
 */

import { DISMISS, SET_SUBSCRIBING_STATUS, SET_EXTENSION_TYPE, TOGGLE_IS_EXPANDED } from "./constants";
import { initialState, State } from "./State";

export function display(state: State = initialState, action): State {
  switch (action.type) {
    case DISMISS:
      return { ...state, isDismissed: true };
    case TOGGLE_IS_EXPANDED:
      return { ...state, isExpanded: !state.isExpanded };
    case SET_SUBSCRIBING_STATUS:
      return { ...state, isSubscribing: action.payload };
    case SET_EXTENSION_TYPE:
      return { ...state, typeOfExtension: action.payload };
    default:
      return state;
  }
}
