/**
 * ErrorMessageModule reducer.
 */

import { SET_GAME_ERROR_MESSAGE, SET_LIVE_CONFIG_ERROR_MESSAGE, SET_MAIN_EXTENSION_ERROR_MESSAGE, CLEAR_GAME_ERROR_MESSAGE, CLEAR_LIVE_CONFIG_ERROR_MESSAGE, CLEAR_MAIN_EXTENSION_ERROR_MESSAGE, SET_CONFIG_ERROR_MESSAGE, CLEAR_CONFIG_ERROR_MESSAGE} from "./constants";
import { initialState, State } from "core/store/modules/ErrorMessage/State";

export function errorMessage(state: State = initialState, action): State {
  if (action.error) {
    return {...state, unhandledErrorMessage: action.payload.message || action.payload}
  }
  switch (action.type) {
    case SET_GAME_ERROR_MESSAGE:
      return {...state, gameErrorMessage: action.payload}
    case SET_LIVE_CONFIG_ERROR_MESSAGE:
      return {...state, liveConfigErrorMessage: action.payload}
    case SET_MAIN_EXTENSION_ERROR_MESSAGE:
      return {...state, mainExtensionErrorMessage: action.payload}
    case SET_CONFIG_ERROR_MESSAGE:
      return {...state, configErrorMessage: action.payload}
    case CLEAR_GAME_ERROR_MESSAGE:
      return {...state, gameErrorMessage: null}
    case CLEAR_LIVE_CONFIG_ERROR_MESSAGE:
      return {...state, liveConfigErrorMessage: null}
    case CLEAR_MAIN_EXTENSION_ERROR_MESSAGE:
      return {...state, mainExtensionErrorMessage: null}
    case CLEAR_CONFIG_ERROR_MESSAGE:
      return {...state, configErrorMessage: null}
    default:
      return state;
  }
}
