import { GameState, DynamoTypes } from "sumo-game-logic";

export interface SessionState {
  channelIsWhitelisted: boolean;
  ongoingSessionExists: boolean;
  matchmaking: boolean;
  automaticMatchStartTimestamp: number;
  matchmakingPlayersCount: number;
  activePlayersCount: number;
  maxPlayersPerGame: number;
  gameState: GameState;
  displayedWinner: DynamoTypes.PlayerMetadata;
  localClockTimeDelta: number;
}

export const initialState: SessionState = {
  channelIsWhitelisted: false,
  ongoingSessionExists: null,
  matchmaking: false,
  automaticMatchStartTimestamp: null,
  matchmakingPlayersCount: 0,
  activePlayersCount: 0,
  maxPlayersPerGame: null,
  gameState: null,
  displayedWinner: null,
  localClockTimeDelta: 0
};