/**
 * DisplayModule reducer.
 */
import { END_GAME_SESSION, HANDLE_MATCHMAKING_UPDATE, GET_GAME_SESSION, GET_GAME_WHITELIST_STATUS, START_MATCHMAKING, LEAVE_GAME, SET_DISPLAYED_WINNER, START_GAME_SESSION, CANCEL_MATCHMAKING, UPDATE_LOCAL_CLOCK_TIME_DELTA } from "./constants";
import { initialState, SessionState } from "./State";

export function game(state: SessionState = initialState, action): SessionState {
  switch (action.type) {
    case UPDATE_LOCAL_CLOCK_TIME_DELTA:
      return { ...state, localClockTimeDelta: action.payload };
    case GET_GAME_WHITELIST_STATUS:
      return { ...state, channelIsWhitelisted: action.payload.channelIsWhitelisted };
    case START_GAME_SESSION:
      return { ...state, ongoingSessionExists: true };
    case END_GAME_SESSION:
      return { ...state, ongoingSessionExists: false };
    case START_MATCHMAKING:
      return { ...state, matchmaking: true };
    case GET_GAME_SESSION:
      return { 
        ...state,
        ongoingSessionExists: action.payload.ongoingSessionExists,
        matchmaking: action.payload.matchmaking,
        gameState: action.payload.gameState
      };
    case HANDLE_MATCHMAKING_UPDATE:
      return {
        ...state,
        automaticMatchStartTimestamp: action.payload.automaticMatchStartTimestamp,
        matchmakingPlayersCount: action.payload.matchmakingPlayersCount,
        activePlayersCount: action.payload.activePlayersCount,
        maxPlayersPerGame: action.payload.maxPlayersPerGame
      }
    case LEAVE_GAME:
      return {
        ...state,
        gameState: null,
        displayedWinner: null,
      }
    case CANCEL_MATCHMAKING:
      return {
        ...state,
        matchmaking: false,
        automaticMatchStartTimestamp: null
      }
    case SET_DISPLAYED_WINNER:
      return {
        ...state,
        displayedWinner: action.payload
      }
    default:
      return state;
  }
}