/**
 * Minigame selectors.
 */

import { name } from "./constants";

export function selectOngoingSessionExists(state) {
  return state[name] && state[name].ongoingSessionExists;
}

export function selectGameState(state) {
  return state[name] && state[name].gameState;
}

export function selectAutomaticMatchStartTimestamp(state) {
  return state[name] && state[name].automaticMatchStartTimestamp;
}

export function selectMatchmakingPlayersCount(state) {
  return state[name] && state[name].matchmakingPlayersCount;
}

export function selectActivePlayersCount(state) {
  return state[name] && state[name].activePlayersCount;
}

export function selectMaxPlayersPerGame(state) {
  return state[name] && state[name].maxPlayersPerGame;
}

export function selectGameId(state) {
  return state[name] && state[name].gameState && state[name].gameState.gameID;
}

export function selectMatchmaking(state) {
  return state[name] && state[name].matchmaking;
}

export function selectDisplayedWinner(state) {
  return state[name] && state[name].displayedWinner;
}

export function selectLocalClockTimeDelta(state) {
  return state[name] && state[name].localClockTimeDelta;
}