import { GET_STREAMER_CONTEXT, INITIAL_VISIBILITY_CHANGE } from "./constants";
import { initialState, State } from "./State";

export function twitch(state = initialState, action): State {
  switch (action.type) {
    case GET_STREAMER_CONTEXT:
      if (action.payload.data && action.payload.data[0]) {
        const user = action.payload.data[0];
        return {
          ... state,
          streamerName: user.display_name,
          streamerType: user.broadcaster_type
        };
      } else {
        return state;
      }
    case INITIAL_VISIBILITY_CHANGE:
      state.receivedInitialVisibilityChangedEvent = true;
      return state;
    default:
      return state;
  }
}