import { name, authorization, context } from './constants'

export function selectTwitchExtension(state) {
  return state[name];
};

export function selectAuthorization(state) {
  return state[name][authorization];
};

export function selectToken(state) {
  return state[name] && state[name][authorization] && state[name][authorization].token || '';
}

export function selectContext(state) {
  return state[name][context];
};

export function selectOpaqueUserId(state) {
  const stateName = state[name];
  const auth = !!stateName && stateName[authorization];
  const userId = !!auth && auth.userId;
  return userId || '';
}

export function selectTheme(state) {
  const stateName = state[name];
  const twitchContext = !!stateName && stateName[context];
  const theme = !!twitchContext && twitchContext.theme;
  return theme || 'default';
}
