import { fetchOverlayExtension } from "core/store/modules/CommunityService";
import { handleTwitchExtensionAuthorized } from "core/store/modules/TwitchExtension";
import { getGameSession } from "../modules/Game";
import { getQueryParam } from 'core/utils/queryParam';

/**
 * Describe business workflow for handling the TwitchExtension Location data.
 *
 * @return a Redux thunk
 */
export default function handleTwitchConfigurationAuthorizationWorkflow(auth) {
  return (dispatch) => {

    // Handle auth data with TwitchExtensionModule
    dispatch(handleTwitchExtensionAuthorized(auth));

    // Kick off SCS API call. We need to call fetchOverlayExtension rather than getOverlayExtensionLocation
    // because we need both the list of experiments the streamer is in and the extension location. 
    // fetchOverlayExtension gives us both of these. 
    const callbackIfWhitelistedForSumo = () => { dispatch(getGameSession({ jwt: auth.token })) };
    const dateOverride = getQueryParam(window.location.search, 'dateOverride');
    dispatch(fetchOverlayExtension({ jwt: auth.token, locale: 'en-US', dateOverride, callbackIfWhitelistedForSumo}));
  };
}
