import { getStreamerContext } from 'core/store/modules/Twitch';
import { getQueryParam } from 'core/utils/queryParam';
import { handleTwitchExtensionAuthorized } from 'core/store/modules/TwitchExtension';
import { fetchOverlayExtension } from 'core/store/modules/CommunityService';
import { getGameSession } from "../modules/Game";

/**
 * Describe business workflow for handling the TwitchExtension Auth data.
 *
 * @return a redux thunk
 */
export default function handleTwitchExtensionAuthorizedWorkflow(auth) {
  return (dispatch) => {

    // Handle auth data with TwitchExtensionModule
    dispatch(handleTwitchExtensionAuthorized(auth));

    // Get the streamer's name.
    dispatch(getStreamerContext({ channelID: auth.channelId }));

    const dateOverride = getQueryParam(window.location.search, 'dateOverride');
    
    const callbackIfWhitelistedForSumo = () => { dispatch(getGameSession({ jwt: auth.token })) };

    // Kick off SCS API call.
    dispatch(fetchOverlayExtension({ jwt: auth.token, locale: 'en-US', dateOverride, callbackIfWhitelistedForSumo}));
  };
}