import { selectToken } from "../modules/TwitchExtension";
import { getGameSession, handleMatchmakingUpdate } from "../modules/Game";

export default function handleTwitchExtensionPubsubBroadcastWorkflow(state, target, type, message) {
  return (dispatch) => {
    try {
      message = JSON.parse(message)
    } catch(error) {
      return;
    }
    
    switch (message.type) {
      case "matchmakingUpdate":
        dispatch(handleMatchmakingUpdate(message))
        // check if the player was added to a new/different game if the matchmaker started new games
        if (message.gamesStartedSinceLastUpdate) {
          dispatch(getGameSession({ jwt: selectToken(state) }));
        }
        break;
      case "sessionUpdate":
        dispatch(getGameSession({ jwt: selectToken(state) }));
        break;
    }
  };
}