import { COMPONENT } from "core/store/modules/Display";
import { isLegacyComponentDesignEnabled } from "core/utils/extensionSettings";
import { INITIAL_VISIBILITY_CHANGE } from "core/store/modules/Twitch/constants"
import { MetricActions } from "core/store/middleware/metrics"
import { Action } from "core/utils/reporter";

/**
 * Handles expand/collapse logic when in the new component design, such as publishing spade events.
 * Twitch handles expanding/collapsing the extension for us in the latest component design
 * See: https://discuss.dev.twitch.tv/t/changes-coming-to-component-extensions-and-how-to-update/21201
 * @return a redux thunk
 */
export default function handleTwitchVisibilityChangedWorkflow(isVisible, typeOfExtension) {
  return (dispatch, getState) => {
    // Twitch publishes an event when the extension first loads. 
    // We ignore it for our metrics since users didn't actually dismiss the extension in this case.
    if (!getState().Twitch.receivedInitialVisibilityChangedEvent) {
      dispatch({ type: INITIAL_VISIBILITY_CHANGE });
      return;
    }

    if (!isLegacyComponentDesignEnabled() && typeOfExtension == COMPONENT) {
      if (isVisible) {
        dispatch({ type: MetricActions.REPORT_EXTENSION_ACTION, payload: Action.Expand });
      } else {
        dispatch({ type: MetricActions.REPORT_EXTENSION_ACTION, payload: Action.Collapse });
      }
    }
  };
}