export interface OverlayExtension {
  hasIdentitySharingEnabled: boolean;
  user: {
    hasPrime: boolean;
    twitchUserId: string;
    opaqueUserId: string;
    credit: {
      balance: number;
      locale: string;
      message: string;
      subscribed: boolean;
    };
    lastSpend: {
      timestamp: string;
      channel: string;
    };
  };
  loot: {
    contentId: string;
    locale: string;
    message: string;
    imageUrl: string;
    destinationLink: string;
    type: LootType;
  };
  signup: {
    destinationLink: string;
  };
  experiments: string[];
  location: Location
}

export enum LootType {
  GAME = "GAME",
  LOOT = "LOOT",
}

/**
 * BOTTOM_MIDDLE is reserved for extension game.
 */
export enum Location {
  TOP_RIGHT = "TOP_RIGHT",
  TOP_MIDDLE = "TOP_MIDDLE",
  TOP_LEFT = "TOP_LEFT",
  BOTTOM_LEFT = "BOTTOM_LEFT",
  BOTTOM_RIGHT = "BOTTOM_RIGHT",
}