import { getQueryParam, addQueryParam } from './queryParam';
import { COMPONENT, OVERLAY, VIDEO_OVERLAY } from "core/store/modules/Display";

export const isLegacyComponentDesignEnabled = () => {
    return getQueryParam(window.location.search, 'legacyComponentDesign')
}

export const getTypeOfExtension = () => {
    return getQueryParam(window.location.search, 'anchor') === VIDEO_OVERLAY ? OVERLAY : COMPONENT;
}

export const generateTwitchParams = (link: string, referralID: string) => {
    link = addQueryParam(link, "twitchReferral", referralID);
    return addQueryParam(link, "ingress", "twch");
}
