
export const getQueryParam = (search: string, param: string) => {
    const name = param.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
    var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
    var results = regex.exec(search);
    return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
}

export const addQueryParam = (link: string, paramName: string, paramValue: string) => {
    if (paramName == "" || link.includes(`${paramName}=${paramValue}`)) {
        return link;
    }
    if (link.includes("?")) {
        return `${link}&${paramName}=${paramValue}`;
    } else {
        return `${link}?${paramName}=${paramValue}`;
    }
}