import * as Cookies from "js-cookie";

import {
  ConsoleReporter,
  MultiReporter,
  Reporter,
  SpadeEvent,
  SpadeReporter,
  fetchSpadeURI,
} from "tachyon-spade-reporter";

export enum Action {
  Dismiss = "dismiss",
  Expand = "expand",
  Collapse = "collapse",
  Subscribe = "subscribe",
  GameLaunch = "game_launch",
  BannerClick = "banner_click",
  UpsellClick = "prime_upsell_click",
}

export interface PrimeExtensionEvent extends SpadeEvent {
  event: string;
  properties: {
    action: Action;
    role: string;
    mode: string;
    channel_id: string;
    user_id: string;
    opaque_user_id: string;
    hasPrime: boolean;
    creditBalance: number;
    game: string;
    extension_type: string;
    extension_location: string;
  };
}
export interface TwitchPrimeSignUpReferredEvent extends SpadeEvent {
  event: string;
  properties: {
    tp_refcode: string;
    tp_campaign: string;
    user_id: string;
    client_time: number;
    device_id: string;
    content: string;
    medium: string;
  };
}

export async function buildReporter(): Promise<Reporter<PrimeExtensionEvent | TwitchPrimeSignUpReferredEvent>> {
  if (process.env.NODE_ENV === "production") {
    return new MultiReporter([
      new SpadeReporter(await fetchSpadeURI()),
    ]);
  } else {
    return new MultiReporter([
      new ConsoleReporter(),
      new SpadeReporter(await fetchSpadeURI()),
    ]);
  }
}

// Logic copied from Twilight, which is their norm. See:
// https://git-aws.internal.justin.tv/twilight/twilight/blob/a3f2a2ac2699d4d2f7e472aeecf4d6c13eca4280/src/common/utils/unique-id.ts#L10
// They have no plans to extract their uuid generation logic into a separate library.
export function generateReferralID() {
  return "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx".replace(/[xy]/g, c => {
    const r = (Math.random() * 16) | 0;
    const v = c === "x" ? r : (r & 0x3) | 0x8;
    return v.toString(16);
  });
}

// The device id cookie gets set by Twilight. See:
// https://git-aws.internal.justin.tv/twilight/twilight/blob/194d6850793077c4e836eb02cc0ad31ffcef641e/src/core/utils/session.ts#L101
// Since extensions are sandboxed, this is the only way for us to get the device id.
const DEVICE_ID_COOKIE = "unique_id";
export function getDeviceID() {
  return Cookies.get(DEVICE_ID_COOKIE);
}
