import { connect } from "react-redux";
import { MatchmakingComponent } from "./component";
import { selectAutomaticMatchStartTimestamp, startMatchmaking, cancelMatchmaking, selectMatchmakingPlayersCount, selectActivePlayersCount, selectMatchmaking, selectLocalClockTimeDelta, selectMaxPlayersPerGame } from "core/store/modules/Game";
import { selectToken } from "core/store/modules/TwitchExtension";

const mapStateToProps = (state) => ({
  automaticMatchStartTimestamp: selectAutomaticMatchStartTimestamp(state),
  matchmaking: selectMatchmaking(state),
  matchmakingPlayersCount: selectMatchmakingPlayersCount(state),
  activePlayersCount: selectActivePlayersCount(state),
  maxPlayersPerGame: selectMaxPlayersPerGame(state),
  token: selectToken(state),
  localClockTimeDelta: selectLocalClockTimeDelta(state)
});

const mapDispatchToProps = (dispatch) => ({
  startMatchmaking: (token) => {
    dispatch(startMatchmaking({ jwt: token }));
  },
  cancelMatchmaking: (token) => {
    dispatch(cancelMatchmaking({ jwt: token }));
  }
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  startMatchmaking: () => dispatchProps.startMatchmaking(stateProps.token),
  cancelMatchmaking: () => dispatchProps.cancelMatchmaking(stateProps.token),
  getCurrentServerTime: () => {  return Date.now() + stateProps.localClockTimeDelta }
});

export const MatchmakingContainer = connect(mapStateToProps, mapDispatchToProps, mergeProps)(MatchmakingComponent);