import * as PIXI from "pixi.js";
import { getPlayerColor, TWITCH_PURPLE_HEX } from "./colorHandler";

const PLAYER_NAME_FONT_SIZE = 15;
const MY_PLAYER_NAME_TEXT_STYLE = new PIXI.TextStyle({
    fill: getPlayerColor(true),
    fontFamily: "\"game-font\"",
    fontSize: PLAYER_NAME_FONT_SIZE,
    dropShadow: true,
    dropShadowDistance: 1
});
const ENEMY_PLAYER_NAME_TEXT_STYLE = new PIXI.TextStyle({
    fill: getPlayerColor(false),
    fontFamily: "\"game-font\"",
    fontSize: PLAYER_NAME_FONT_SIZE,
    dropShadow: true,
    dropShadowDistance: 1
});

export function getPlayerNameTextStyle(isMyPlayer: boolean) {
    return isMyPlayer? MY_PLAYER_NAME_TEXT_STYLE : ENEMY_PLAYER_NAME_TEXT_STYLE;
}


const COUNTDOWN_TEXT_COLOR = TWITCH_PURPLE_HEX;
export const COUNTDOWN_TEXT_STYLE = new PIXI.TextStyle({
    fill: COUNTDOWN_TEXT_COLOR,
    fontFamily: "\"game-font-countdown\"",
    fontSize: 200
});

export const STATUS_TEXT_STYLE = new PIXI.TextStyle({
    fill: 0xffffff,
    fontFamily: "\"game-font\"",
    fontSize: 200,
    dropShadow: true,
    dropShadowDistance: 2
});