import { connect } from "react-redux";
import { SumoGameViewComponent } from "./component";
import { selectGameState } from "core/store/modules/Game";
import { selectOpaqueUserId, selectToken } from "core/store/modules/TwitchExtension";
import { submitGameInput, getGameSession, setDisplayedWinner, selectLocalClockTimeDelta } from "core/store/modules/Game";

const mapStateToProps = (state) => ({
  gameState: selectGameState(state),
  token: selectToken(state),
  myOpaqueUserID: selectOpaqueUserId(state),
  localClockTimeDelta: selectLocalClockTimeDelta(state)
});

const mapDispatchToProps = (dispatch) => ({
  submitGameInput: (token, input) => {
    dispatch(submitGameInput({ jwt: token, input: input }));
  },
  getGameSession: (token) => {
    dispatch(getGameSession({ jwt: token }));
  },
  setDisplayedWinner: (displayedWinner) => {
    dispatch(setDisplayedWinner(displayedWinner));
  },
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  onGameInput: (input) => {
    dispatchProps.submitGameInput(stateProps.token, input);
  },
  getGameSession: () => dispatchProps.getGameSession(stateProps.token, stateProps.gameID),
  getCurrentServerTime: () => {  return Date.now() + stateProps.localClockTimeDelta }
});

export const SumoGameViewContainer = connect(mapStateToProps, mapDispatchToProps, mergeProps)(SumoGameViewComponent);