import { selectIsPrime } from "core/store/modules/CommunityService";
import { connect } from "react-redux";
import { ExtensionGameComponent } from "./component";
import { selectToken, selectOpaqueUserId } from "core/store/modules/TwitchExtension";
import { leaveGame, selectDisplayedWinner, selectGameState, selectOngoingSessionExists, selectMatchmaking, selectMaxPlayersPerGame } from "core/store/modules/Game";
import { selectGameErrorMessage } from "core/store/modules/ErrorMessage";

const mapStateToProps = (state) => ({
  isPrime: selectIsPrime(state),
  token: selectToken(state),
  opaqueUserId: selectOpaqueUserId(state),
  displayedWinner: selectDisplayedWinner(state),
  ongoingSessionExists: selectOngoingSessionExists(state),
  gameState: selectGameState(state),
  matchmaking: selectMatchmaking(state),
  maxPlayersPerGame: selectMaxPlayersPerGame(state),
  errorMessage: selectGameErrorMessage(state)
});

const mapDispatchToProps = (dispatch) => ({
  leaveGame: (token) => {
    dispatch(leaveGame({ jwt: token }));
  }
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  leaveGame: () => {
    dispatchProps.leaveGame(stateProps.token);
  }
});

export const ExtensionGameContainer = connect(mapStateToProps, mapDispatchToProps, mergeProps)(ExtensionGameComponent);