import { connect } from "react-redux";
import { endGameSession, selectOngoingSessionExists, startGameSession } from "core/store/modules/Game";
import { selectLocation, selectIsWhiteListedForSumo } from "core/store/modules/CommunityService";
import { RootComponent } from "./component";
import { selectTypeOfExtension } from "core/store/modules/Display";
import { Action } from "../../core/utils/reporter";
import { selectTheme, selectToken } from "core/store/modules/TwitchExtension";
import { selectLiveConfigErrorMessage } from "core/store/modules/ErrorMessage/selectors";
import { MetricActions } from "core/store/middleware/metrics"

const mapStateToProps = (state) => ({
  errorMessage: selectLiveConfigErrorMessage(state),
  extensionLocation: selectLocation(state),
  theme: selectTheme(state),
  typeOfExtension: selectTypeOfExtension(state),
  ongoingSessionExists: selectOngoingSessionExists(state),
  channelIsWhitelistedForSumo: selectIsWhiteListedForSumo(state),
  token: selectToken(state),
});

const mapDispatchToProps = (dispatch) => ({
  report: (action: Action) => {
    dispatch({
      payload: action,
      type: MetricActions.REPORT_EXTENSION_ACTION,
    });
  },
  startGameSession: (token) => {
    dispatch(startGameSession({ jwt: token }));
  },
  endGameSession: (token) => {
    dispatch(endGameSession({ jwt: token }));
  }
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  onStartGameSession: () => dispatchProps.startGameSession(stateProps.token),
  onEndGameSession: () => dispatchProps.endGameSession(stateProps.token),
});

export const RootContainer = connect(mapStateToProps, mapDispatchToProps, mergeProps)(RootComponent);
