import { Location } from "core/types/CommunityService";
import * as React from "react";
import { Select } from "twitch-core-ui";

export interface Props {
  extensionLocation: Location;
  onDropdownChange: (location) => void;
}

export class DropdownComponent extends React.Component<Props> {

  public render() {
    const extensionLocation = this.props.extensionLocation;
    const friendlyNames = this.createFriendlyNames();
    return (
      <div className="extension-location-dropdown">
        <Select value={extensionLocation} onChange={this.onChange}>
          <option value={Location.TOP_RIGHT}>{friendlyNames.get(Location.TOP_RIGHT)}</option>
          <option value={Location.TOP_MIDDLE}>{friendlyNames.get(Location.TOP_MIDDLE)}</option>
          <option value={Location.TOP_LEFT}>{friendlyNames.get(Location.TOP_LEFT)}</option>
          <option value={Location.BOTTOM_LEFT}>{friendlyNames.get(Location.BOTTOM_LEFT)}</option>
          <option value={Location.BOTTOM_RIGHT}>{friendlyNames.get(Location.BOTTOM_RIGHT)}</option>
        </Select>
      </div>
    );
  }

  private onChange = (event) => {
    this.props.onDropdownChange(event.target.value);
  }

  /**
   * Creates frontend readable names from the Location enum.
   * @returns {Map<string, string>} A map of frontend readable names.
   */
  private createFriendlyNames = () => {
    const friendlyName: Map<string, string> = new Map<string, string>();
    for (const rawLocation in Location) {
      const extensionLocation = rawLocation
          .charAt(0) +
        rawLocation
          .substring(1)
          .toLowerCase()
          .replace("_", " ");
      friendlyName.set(rawLocation, extensionLocation);
    }
    return (friendlyName);
  }
}
