import { setOverlayExtensionLocation, selectLocation } from "core/store/modules/CommunityService";
import { selectToken } from "core/store/modules/TwitchExtension";
import { connect } from "react-redux";
import { DropdownComponent } from "./component";

const mapStateToProps = (state) => ({
  extensionLocation: selectLocation(state),
  token: selectToken(state),
});

const mapDispatchToProps = (dispatch) => ({
  setLocation: (token, extensionLocation) => {
    dispatch(setOverlayExtensionLocation({ jwt: token, location: extensionLocation }));
  },
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  onDropdownChange: (location) => dispatchProps.setLocation(stateProps.token, location),
});

export const DropdownContainer = connect(mapStateToProps, mapDispatchToProps, mergeProps)(DropdownComponent);
