import { shallow } from "enzyme";
import * as React from "react";
import { InFeatureNotification, InFeatureNotificationType } from "twitch-core-ui";
import { Props, ErrorMessageComponent } from "./component";

const createComponent = (props: Props) => {
  return (
    <ErrorMessageComponent message={props.message} closeButtonOnClick={props.closeButtonOnClick}/>
  );
}

const setupShallow = (props: Props) => {
  return shallow(createComponent(props));
}

describe("Error message component", () => {
  it("renders an error InFeatureNotification core-ui component", () => {
    const component = setupShallow({ message: '', closeButtonOnClick: () => {} });
    expect(component.find(InFeatureNotification)).toHaveLength(1);
    expect(component.find(InFeatureNotification).prop('type')).toEqual(InFeatureNotificationType.Error);
  });

  it("passes props correctly", () => {
    const message = "message";
    const closeButtonOnClick = jest.fn();
    const component = setupShallow({ message: message, closeButtonOnClick: closeButtonOnClick });
    expect(component.find(InFeatureNotification).prop('title')).toEqual(message);
    expect(component.find(InFeatureNotification).prop('closeButtonOnClick')).toEqual(closeButtonOnClick);
  });
});
