import * as React from "react";
import {InFeatureNotification, InFeatureNotificationType, StyledLayout} from 'twitch-core-ui';

export interface Props {
    message: string;
    closeButtonOnClick: () => void;
}

export class ErrorMessageComponent extends React.Component<Props> {
    public render() {
        return (
            <StyledLayout margin={{ bottom: 1 }} >
                <InFeatureNotification 
                    closeButtonOnClick={this.props.closeButtonOnClick} 
                    closeButtonAriaLabel='x' 
                    description={null}
                    title={this.props.message}
                    type={InFeatureNotificationType.Error} 
                />
            </StyledLayout>
        );
    }
}
