import * as React from "react";
import "./styles.scss";
import { Display, JustifyContent, StyledLayout } from "twitch-core-ui";

export interface Props {
  isSelected: boolean;
  location: string;
  onSelection: (location) => void;
}

export class SelectableLocationComponent extends React.Component<Props> {

  public render() {

    if (this.props.isSelected) {
      return (
        <StyledLayout 
          display={Display.Flex}
          className="selectable-location selectable-location__selected-location"
          justifyContent={JustifyContent.Center}
        >
          <img className="selectable-location__selected-location__icon" src="https://m.media-amazon.com/images/G/01/sm/reminder-extension/crown_PurpleRoyale_ice_72x72.svg"></img>
        </StyledLayout>);
    }
    
    return (
      <div className="selectable-location selectable-location__unselected-location"
        onClick={() => this.props.onSelection(this.props.location)}
      />
    );

  }
}
