import * as React from "react";
import "./styles.scss";
import { SelectableLocation } from "../SelectableLocation";
import { Location } from 'core/types/CommunityService'
import { AlignSelf, Background, Display, FlexDirection, JustifyContent, StyledLayout } from "twitch-core-ui";

export interface Props {
  extensionLocation: Location;
}

export class StreamLocationPreviewComponent extends React.Component<Props> {

  public render() {
    return (
      <StyledLayout
        background={Background.Alt}
        border={true}
        className="stream-location-preview"
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        justifyContent={JustifyContent.Between}
        margin={{ bottom: 1 }}
      >
        <StyledLayout
          alignSelf={AlignSelf.Start}
          display={Display.Flex}
          fullWidth={true}
          justifyContent={JustifyContent.Between}
        >
          <SelectableLocation isSelected={this.isCrownLocation(Location.TOP_LEFT)} location={Location.TOP_LEFT} />
          <SelectableLocation isSelected={this.isCrownLocation(Location.TOP_MIDDLE)} location={Location.TOP_MIDDLE} />
          <SelectableLocation isSelected={this.isCrownLocation(Location.TOP_RIGHT)} location={Location.TOP_RIGHT} />
        </StyledLayout>
        <StyledLayout
          alignSelf={AlignSelf.End}
          display={Display.Flex}
          fullWidth={true}
          justifyContent={JustifyContent.Between}
        >
          <SelectableLocation isSelected={this.isCrownLocation(Location.BOTTOM_LEFT)} location={Location.BOTTOM_LEFT} />
          <SelectableLocation isSelected={this.isCrownLocation(Location.BOTTOM_RIGHT)} location={Location.BOTTOM_RIGHT} />
        </StyledLayout>
      </StyledLayout>
    );
  }

  private isCrownLocation = (location) => this.props.extensionLocation === location;
}
