declare var Twitch: any;

import { setTypeOfExtension } from "core/store/modules/Display";
import { setLiveConfigErrorMessage } from "core/store/modules/ErrorMessage";
import { handleTwitchExtensionContext } from "core/store/modules/TwitchExtension";
import handleTwitchConfigurationAuthorizationWorkflow from "core/store/workflows/handleTwitchConfigurationAuthorizationWorkflow";

/**
 * @param store a redux store
 */
export default function connectLiveConfigurationPage(store, typeOfExtension) {
  if (!Twitch) {
    store.dispatch(setLiveConfigErrorMessage("Twitch init failed."));
    return;
  }
  store.dispatch(setTypeOfExtension(typeOfExtension));
  Twitch.ext.onAuthorized((auth) => store.dispatch(handleTwitchConfigurationAuthorizationWorkflow(auth)));
  Twitch.ext.onContext((context) => store.dispatch(handleTwitchExtensionContext(context)));
}
