import connectLiveConfigurationPage from "live_config/connectLiveConfigurationPage";
import configureStore from "core/store/configureStore";
import { COMPONENT, OVERLAY, VIDEO_OVERLAY } from "core/store/modules/Display";
import { getQueryParam } from 'core/utils/queryParam';
import * as React from "react";
import { render } from "react-dom";
import { Provider } from "react-redux";
import { Root } from "live_config/Root";
import rootReducer from "live_config/rootReducer";
import "whatwg-fetch";

async function start(): Promise<void> {

  const store = await configureStore(rootReducer);

  const anchor = getQueryParam(window.location.search, 'anchor');
  let typeOfExtension = anchor === VIDEO_OVERLAY ? OVERLAY : COMPONENT;

  connectLiveConfigurationPage(store, typeOfExtension);

  render(
    <Provider store={store}>
      <Root/>
    </Provider>,
    document.getElementById("root"),
  );
}

start();
