import { selectCommunityService, selectIsPrime, selectLocation, selectIsWhiteListedForSumo } from "core/store/modules/CommunityService";
import { selectOngoingSessionExists, selectGameId } from "core/store/modules/Game";
import { selectIsDismissed, selectIsExpanded, selectTypeOfExtension } from "core/store/modules/Display";
import { selectMainExtensionErrorMessage, selectUnhandledErrorMessage } from "core/store/modules/ErrorMessage";
import { Action } from "core/utils/reporter";
import { RootComponent } from "./component";
import { connect } from "react-redux";
import { MetricActions } from "core/store/middleware/metrics"

const mapStateToProps = (state) => ({
  communityServiceLoaded: !!selectCommunityService(state),
  error: !!selectMainExtensionErrorMessage(state) || !!selectUnhandledErrorMessage(state),
  isDismissed: selectIsDismissed(state),
  isExpanded: selectIsExpanded(state),
  isPrime: selectIsPrime(state),
  typeOfExtension: selectTypeOfExtension(state),
  showGameLauncher: selectIsWhiteListedForSumo(state) && (selectOngoingSessionExists(state) || !!selectGameId(state)),
  location: selectLocation(state),
});

const mapDispatchToProps = (dispatch) => ({
  reportClick: () => {
    dispatch({ type: MetricActions.REPORT_EXTENSION_ACTION, payload: Action.GameLaunch });
  },
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  reportGameLaunch: () => dispatchProps.reportClick(),
});

export const RootContainer = connect(mapStateToProps, mapDispatchToProps, mergeProps)(RootComponent);
