import * as React from "react";
import { SVG, SVGAsset } from "twitch-core-ui";
import "./styles.scss";

export interface Props {
  dismiss: () => void;
}

export const DismissButtonComponent: React.SFC<Props> = ({ dismiss }: Props) => (
  <button className="dismiss-button" onClick={dismiss}>
    <SVG asset={SVGAsset.Close} />
  </button>
);
