import {
  selectHasCredit,
  selectIsPrime,
  selectSubscribed,
  selectType} from "core/store/modules/CommunityService";
import { selectIsExpanded, selectIsSubscribing, toggleIsExpanded } from "core/store/modules/Display";
import { selectMainExtensionErrorMessage, selectUnhandledErrorMessage } from "core/store/modules/ErrorMessage";
import { selectOpaqueUserId } from "core/store/modules/TwitchExtension";
import { Action } from "core/utils/reporter";
import { connect } from "react-redux";
import { DropdownButtonComponent } from "./component";
import { selectCanSubscribeToStreamer } from "core/store/modules/Twitch";
import { MetricActions } from "core/store/middleware/metrics"

const mapStateToProps = (state) => ({
  canSubscribe: selectHasCredit(state),
  canSubscribeToStreamer: selectCanSubscribeToStreamer(state),
  error: !!selectMainExtensionErrorMessage(state) || !!selectUnhandledErrorMessage(state),
  isExpanded: selectIsExpanded(state),
  isPrime: selectIsPrime(state),
  isSubscribing: selectIsSubscribing(state),
  subscribed: selectSubscribed(state),
  type: selectType(state),
  opaqueUserId: selectOpaqueUserId(state),
});

const mapDispatchToProps = (dispatch) => ({
  report: (action: Action) => {
    dispatch({
      payload: action,
      type: MetricActions.REPORT_EXTENSION_ACTION,
    });
  },
  toggle: () => {
    dispatch(toggleIsExpanded());
  },
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  toggle: () => {
    dispatchProps.report(stateProps.isExpanded ? Action.Collapse : Action.Expand);
    dispatchProps.toggle();
  },
});

export const DropdownButtonContainer = connect(
  mapStateToProps,
  mapDispatchToProps,
  mergeProps,
)(DropdownButtonComponent);
