import * as React from "react";
import { Background, CoreText, FontSize, StyledLayout, SVG, SVGAsset, SVGType, TextAlign } from "twitch-core-ui";
import './styles.scss';

// Props shape.
export interface Props {
  error: string;
}

export class ErrorComponent extends React.Component<Props> {
  public render() {
    const errorMessages = {
      HAS_PAID_SUB: "You’re already subscribed to this broadcaster.",
      NO_BALANCE: "You’ve already used your Prime subscription. Refresh the page to update this extension.",
    };
    const errorMessage = errorMessages[this.props.error] ||
      "Something went wrong. Check your connection or try refreshing the page.";
    const showGlitch = !errorMessages[this.props.error];

    return (
      <div className="error">
        <StyledLayout textAlign={TextAlign.Center} background={Background.Base} padding={1}>
          {showGlitch && (
            <SVG
            asset={SVGAsset.DeadGlitch}
            height={40}
            width={40} />
          )}
          <StyledLayout textAlign={TextAlign.Left}>
            <CoreText fontSize={FontSize.Size7}>
              {errorMessage}
            </CoreText>
          </StyledLayout>
        </StyledLayout>
      </div>
    );
  }
}
