import * as React from "react";
import "./styles.scss";
import { generateReferralID } from "core/utils/reporter";
import { getTypeOfExtension, generateTwitchParams } from "core/utils/extensionSettings";

export const OFFER_BANNER = "offer__banner";

export interface Props {
  offerID: string;
  offerMessage: string;
  offerImage: string;
  offerLink: string;
  reportClick: (referralID, offerID) => void;
}

export class OfferComponent extends React.PureComponent<Props> {

  public render() {
    const referralID = generateReferralID();
    const link = generateTwitchParams(this.props.offerLink, referralID);
    return (
      <div className={"offer"}>
        <p className={`offer__offer-message offer__offer-message_font--${getTypeOfExtension()}`}>{this.props.offerMessage}</p>
        <a
          href={ link }
          data-test-target={ OFFER_BANNER }
          onClick={() => { this.props.reportClick(referralID, this.props) } }
          target="_blank"
        >
          <img className="offer__offer-image" src={this.props.offerImage} />
        </a>
      </div>
    )
  }
}
