import { selectContentImage, selectContentMessage, selectOfferLink, selectOfferID } from "core/store/modules/CommunityService";
import { MetricActions } from "core/store/middleware/metrics"
import { connect } from "react-redux";
import { Action } from "core/utils/reporter";
import { OfferComponent } from "./component";

const mapStateToProps = (state) => ({
  offerID: selectOfferID(state),
  offerImage: selectContentImage(state),
  offerLink: selectOfferLink(state),
  offerMessage: selectContentMessage(state),
});

const mapDispatchToProps = (dispatch) => ({
  reportClick: (referralID, ownProps) => {
    dispatch({ type: MetricActions.REPORT_EXTENSION_ACTION, payload: Action.BannerClick });
    dispatch({ type: MetricActions.REPORT_TWITCH_PRIME_REFERRAL, payload: {referralID, offerID: ownProps.offerID, medium: "prime_extension_offer_upsell"} });
  },
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
});

export const OfferContainer = connect(mapStateToProps, mapDispatchToProps, mergeProps)(OfferComponent);
