import { selectHasCredit, selectSubscribed, selectSubscribedTime, selectSubscribedChannel, spendSubscriptionCredit } from "core/store/modules/CommunityService";
import { selectIsSubscribing, SET_SUBSCRIBING_STATUS } from "core/store/modules/Display";
import { selectCanSubscribeToStreamer, selectStreamerName } from "core/store/modules/Twitch";
import { MetricActions } from "core/store/middleware/metrics"
import { selectToken } from "core/store/modules/TwitchExtension";
import { Action } from "core/utils/reporter";
import { connect } from "react-redux";
import { SubscriptionComponent } from "./component";

const mapStateToProps = (state) => ({
  canSubscribeToStreamer: selectCanSubscribeToStreamer(state),
  hasCredit: selectHasCredit(state),
  streamerName: selectStreamerName(state),
  subscribed: selectSubscribed(state),
  isSubscribing: selectIsSubscribing(state),
  token: selectToken(state),
  subscribedTime: selectSubscribedTime(state),
  subscribedChannel: selectSubscribedChannel(state),
});

const mapDispatchToProps = (dispatch) => ({
  subscribe: (token) => {
    dispatch({ type: MetricActions.REPORT_EXTENSION_ACTION, payload: Action.Subscribe });
    dispatch(spendSubscriptionCredit({ jwt: token }));
    this.setSubscribingStatus(true);
  },
  setSubscribingStatus: (status: boolean) => {
    dispatch({ type: "SET_SUBSCRIBING_STATUS", payload: status });
  },
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  onSubscribeClick: () => dispatchProps.subscribe(stateProps.token),
  setSubscribingStatus: (status: boolean) => dispatchProps.setSubscribingStatus(status),
});

export const SubscriptionContainer = connect(mapStateToProps, mapDispatchToProps, mergeProps)(SubscriptionComponent);
