import * as React from "react";
import "./styles.scss";
import { generateReferralID } from "core/utils/reporter";
import { getTypeOfExtension, generateTwitchParams } from "core/utils/extensionSettings";

export const UPSELL_BANNER = "upsell_banner";

export interface Props {
  offerID: string;
  signupLink: string;
  reportClick: (referralID, offerID) => void;
}

export class UpsellComponent extends React.PureComponent<Props> {

  public render() {
    const referralID = generateReferralID();
    const link = generateTwitchParams(this.props.signupLink, referralID);
    return (
      <a
        href={link}
        className={"upsell__link"}
        data-test-target={UPSELL_BANNER}
        onClick={() => { this.props.reportClick(referralID, this.props) }}
        target="_blank"
      >
        <div className={"upsell"}>
          <img className="upsell__banner-image" src="https://m.media-amazon.com/images/G/01/sm/reminder-extension/PrimeGaming_PurpleRoyale.svg" alt="Prime Gaming"/>
          <p className={`upsell__message upsell__message_font--${getTypeOfExtension()}`}>Get a free channel subscription &amp; more each month.</p>
        </div>
      </a>
    )
  }
}
