import { selectOfferID, selectSignUpLink} from "core/store/modules/CommunityService";
import { MetricActions } from "core/store/middleware/metrics"
import { connect } from "react-redux";
import { Action } from "core/utils/reporter";
import { UpsellComponent } from "./component";

const mapStateToProps = (state) => ({
  offerID: selectOfferID(state),
  signupLink: selectSignUpLink(state),
});

const mapDispatchToProps = (dispatch) => ({
  reportClick: (referralID, ownProps) => {
    dispatch({ type: MetricActions.REPORT_EXTENSION_ACTION, payload: Action.UpsellClick });
    dispatch({ type: MetricActions.REPORT_TWITCH_PRIME_REFERRAL, payload: {referralID, offerID: ownProps.offerID, medium: "prime_extension_tp_upsell" } });
  },
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
});

export const UpsellContainer = connect(mapStateToProps, mapDispatchToProps, mergeProps)(UpsellComponent);
