import { combineReducers } from 'redux';
import ErrorMessageModule, { errorMessage } from 'core/store/modules/ErrorMessage';
import DisplayModule, { display } from 'core/store/modules/Display';
import TwitchExtensionModule, { twitchExtension } from 'core/store/modules/TwitchExtension';
import CommunityServiceModule, { communityService } from 'core/store/modules/CommunityService'
import GameModule, { game } from 'core/store/modules/Game'
import TwitchModule, { twitch } from 'core/store/modules/Twitch'

export default combineReducers({
  [ErrorMessageModule]: errorMessage,
  [DisplayModule]: display,
  [TwitchExtensionModule]: twitchExtension,
  [CommunityServiceModule]: communityService,
  [GameModule]: game,
  [TwitchModule]: twitch
});
