package main

import (
	"github.com/cactus/go-statsd-client/statsd"

	"time"

	"code.justin.tv/foundation/twitchserver"
	"code.justin.tv/samus/red-dot/config"
	"code.justin.tv/samus/red-dot/internal/api"
	log "github.com/sirupsen/logrus"
)

const (
	prodEnvironment = "prod"
)

func main() {
	environment := config.GetEnvironment()

	logLevel := log.DebugLevel
	if environment == prodEnvironment {
		logLevel = log.InfoLevel
	}
	log.SetLevel(logLevel)
	log.SetFormatter(&log.TextFormatter{FullTimestamp: true, TimestampFormat: time.RFC3339})

	stats, err := statsd.NewNoopClient()
	if err != nil {
		log.WithError(err).Fatal("Failed to initialize statsd client")
	}
	err = startWebServer(stats)
	if err != nil {
		log.Fatalf("Error during server shutdown: %v", err)
	}
}

// Set up the web server start listening for requests.
func startWebServer(stats statsd.Statter) error {
	environment := config.GetEnvironment()
	cfg, err := config.LoadConfigForEnvironment(environment)
	if err != nil {
		log.Fatal(err)
	}

	// clients, err := clients.SetupClients(cfg)
	// if err != nil {
	// 	log.Fatalf("Failed to initialize clients: %s", err)
	// }

	offerStatusAPI := api.OfferStatusAPI{}

	redDotServer := api.RedDotServer{
		OfferStatusAPI: offerStatusAPI,
	}

	server, err := redDotServer.NewServer(stats, cfg)
	if err != nil {
		log.Fatal(err)
	}

	log.Info("Starting Red Dot server")

	serverConfig := twitchserver.NewConfig()
	serverConfig.Statter = stats
	twitchserver.AddDefaultSignalHandlers()
	return twitchserver.ListenAndServe(server, serverConfig)
}
