#!/bin/bash

set -e

ACCOUNT=$1

case "$ACCOUNT" in
        red-dot-staging)
            ENVIRONMENTS=(staging)
            ;;
        red-dot-prod)
            ENVIRONMENTS=(prod)
            ;;
        *)
            echo "Unknown account \"$ACCOUNT\", exiting"
            exit 1
esac

cd ./terraform/${ACCOUNT}

for ENVIRONMENT in "${ENVIRONMENTS[@]}"
do
    ROLE=`terraform output ${ENVIRONMENT}-iam_role_arn`

    tcs sandstorm role-flags \
        --owner team-samus \
        --name samus-${ENVIRONMENT}-red-dot \
        --secret_key "samus/red-dot/${ENVIRONMENT}/*" \
        --allowed_arn "${ROLE}" \
        --output ./sandstorm.d/${ACCOUNT}_${ENVIRONMENT}.json

done
