

module "bs-prod" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "red-dot-prod"
  aws_region = "us-west-2"
  eb_application_name = "${module.bs-app-red-dot-prod.beanstalk_application_name}"
  vpc_id = "vpc-d0ce86a9"
  ec2_subnet_ids = "subnet-ceb76485,subnet-695aeb10,subnet-48e87912"
  elb_subnet_ids = "subnet-ceb76485,subnet-695aeb10,subnet-48e87912"
  elb_loadbalancer_security_groups = "sg-ce04deb0"
  auto_scaling_lc_security_groups = "sg-ce04deb0"
  solution_stack_name = "64bit Amazon Linux 2017.09 v2.8.3 running Docker 17.06.2-ce"
  auto_scaling_lc_keypair_name = "samus-red-dot-prod"
  auto_scaling_lc_instance_type = "c5.xlarge"
  owner = "samus-aws+sots-prod@amazon.com"
  service = "samus/red-dot"
  env = "prod"
  associate_public_address = "false"
  cname_prefix = "prod-red-dot"

}
