

module "bs-staging" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "red-dot-staging"
  aws_region = "us-west-2"
  eb_application_name = "${module.bs-app-red-dot-staging.beanstalk_application_name}"
  vpc_id = "vpc-9dce86e4"
  ec2_subnet_ids = "subnet-9cb665d7,subnet-425fee3b,subnet-0fef7e55"
  elb_subnet_ids = "subnet-9cb665d7,subnet-425fee3b,subnet-0fef7e55"
  elb_loadbalancer_security_groups = "sg-2233e95c"
  auto_scaling_lc_security_groups = "sg-2233e95c"
  solution_stack_name = "64bit Amazon Linux 2017.09 v2.8.3 running Docker 17.06.2-ce"
  auto_scaling_lc_keypair_name = "samus-red-dot-stg"
  auto_scaling_lc_instance_type = "c5.xlarge"
  owner = "samus-aws+sots-prod@amazon.com"
  service = "samus/red-dot"
  env = "staging"
  associate_public_address = "false"
  cname_prefix = "staging-red-dot"

}
