Rex Overview
=============
This service manages Twitch Prime offers on Twitch.tv

API
=============
[API Documentation](internal/api/api.md)

| Environment   | Endpoint                                   |
| ------------- |--------------------------------------------|
| Development   | http://localhost:8000     |
| Staging       | http://staging-rex.us-west-2.elasticbeanstalk.com     |
| Production    | http://prod-rex.us-west-2.elasticbeanstalk.com    |

## Overview

![Overview Diagram](https://docs.google.com/a/justin.tv/drawings/d/e/2PACX-1vQ8GaIyAKdxFt-BG-U-c8m5LMq5ysKAYCECQVep86FMT5YzueYZ1uO-vUZamNJ7nkE5hNx5ZQev3hQj/pub?w=599&amp;h=491)

## Setting Up the Go Service

### Setting up your Github account

 - Go to your account settings page (https://git.xarth.tv/settings/keys) and follow the instructions there to add a new SSH key to your account.

### Setting up your workspace

 - Install go:

		brew install go@1.15

 - Create a Go workspace folder in your home directory. Ex:

		mkdir /Users/$(whoami)/GoWorkspace

 - Set your environment variable for GOPATH (in your .bashrc, .zshrc, or etc.)

		export GOPATH=/Users/$(whoami)/GoWorkspace

 - Append GOPATH/bin to PATH environment variable

		export PATH=$PATH:$GOPATH/bin

 - To check if Go installed correctly, run go version from commandline. This version should more than 1.9

 - Clone down rex source within the new gopath. You'll need to be on the twitch VPN for this to work.
 
		git clone https://git.xarth.tv/samus/rex.git

 - Directory structure will now look like this:

		/Users/$(whoami)/GoWorkspace/src/rex
		
- Setup dev tools, this will allow you to run things like lint and format. You must install Protobuf and Mockery separately. 
You can follow the installation instructions for each: 

- https://github.com/vektra/mockery
- https://medium.com/@erika_dike/installing-the-protobuf-compiler-on-a-mac-a0d397af46b8

When you're done you should see:

```
protoc --version
libprotoc 3.15.6

mockery --version
08 Apr 21 11:13 PDT INF Starting mockery dry-run=false version=2.7.4
2.7.4
```

```
make dev-setup 
```

### Setup dependencies

```
go mod tidy && go mod vendor 
```

#### Adding Dependencies
If you run just:
```
go get dependency@version 
```

You may see your dependency get added to go.mod as "indirect" dependency. 
If this is the case, make sure the dependency is imported somewhere in your code, 
run the "go get" command your dependency again, then run go mod tidy && go mod vendor. 

#### Further Reading
https://golang.org/ref/mod

### AWS
```{ Not Required for Server Yet } ```
Running Rex locally may require an IAM user in the future with access credentials on the appropriate AWS account. [Ensure you have the AWS CLI installed](https://docs.aws.amazon.com/cli/latest/userguide/installing.html), then set up your IAM user and credentials:

There are two options for running the server locally.
NEW:
1. Follow the instructions: https://w.amazon.com/index.php/AmazonAwsCli/Cookbook#OSX - Note you may have some python version issues to work through
2. Ensure the profile you create is named correctly with what is needed in the Makefile under `make dev` [rex-staging]

OLD:
1. In [Isengard](https://isengard.amazon.com), access the Admin console for the Rex account you need credentials for (either `samus-rex-prod` for production or `samus-rex-dev` for development).
2. Navigate to [IAM](https://console.aws.amazon.com/iam/home) and visit the Users tab on the left.
3. Click "Add user" in the top left. Enter a username and check "Programmatic access" as the access type. Go to the next step.
4. Attach "AdministratorAccess" permission policy. Complete the creation flow.
5. At the final step, you should be shown the new user's `AWS_ACCESS_KEY` and `AWS_SECRET_ACCESS_KEY`. You'll use these to create your local AWS profile. Note that after this point you cannot view the secret access key again; if you lose the secret access key, you'll have to create new credentials.
6. In your terminal, run `aws configure --profile rex-staging`. Enter the access key and secret access key you just created when the CLI prompts you.


### Making a code change
 - Create a new git branch : git checkout -b <branch name>

 - git push origin <branch name>

 - Click compare and pull request on the git website for your package

 - Make changes and commit to the branch. Do not use commit --amend --no-edit. Push the commits

 - When you get a +1 to your pull request, do "Squash and merge your changes"
 Note: Make a separate branch/commit for your vendor changes if possible to avoid reviewers having to see massive file changes

### Building, Compiling, Testing, Running

        make install
        make verify

 - The production build is created with the commands in build.json


Development and Elastic Beanstalk setup
===========
1. In order to use the tools described in this section, you must install them as a one time setup step. Use the following commnads to install the tools:
```
		make dev-setup
```

2.Take a look at the Makefile to see the targets that are available. Examples:
```
		make formt   // runs formatting on your Go files
		make lint  // checks for mechanical errors and ill-formatted conventions
		make dev // similar to brazil-build server (starts the service but must be on the Twitch VPN)
```

3. Application is created using ElasticBeanstalk and Twitch Create Service .
* [EB Config](.elasticbeanstalk). [Refer here.](http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/eb3-config.html)
* [Twitch Create Service](https://git.xarth.tv/dta/tcs)

4. Run tests and check code coverage using [GoConvey](https://github.com/smartystreets/goconvey)
```
    make test
```

Run the server
```
    make dev
```

# Mocks
- Use [Testify](https://github.com/stretchr/testify) to mock out behavior in tests
- Use [Mockery](https://github.com/vektra/mockery) to autogenerate mock classes

- Install mockery through your preferred method, brew or docker - current used version: 2.7.4

Example mockery generation:

```
$ mockery --dir=internal/clients/subs --name=ISubServiceClient
```
... where `dir` is the source directory and `name` is the name of the interface to be mocked. The default output goes to `./mocks`

You can also add it in the Makefile and generate it by running:

```
$ make mocks
```

# Integration tests
Integration tests live in the `./integration_test` directory.
To run them against your local code:

	make integration-test-dev

To run them against our staging server:

    make integration-test
    
Note: `make integration-test` still runs against your local code, it just uses the staging environment data.
The `Reset` function in `offer_statuses_api_integration_test.go` only works in prod and will not delete the offers in staging. 
The offers in staging will need to manually be deleted from the `OfferStatus` table.


# Jenkins pipeline
[View Pipeline in Jenkins](https://jenkins-og.xarth.tv/job/samus/job/rex/job/master/)

**NOTE: The `jenkinsfile` auto deploys to staging and prod after you merge the code to master in your PR. [The Deploy Tool](https://deploy.xarth.tv/#/samus/rex) is only used to track the progress of this build and not to deploy staging or prod. You will see this error if you try to deploy using the deploy tool:**

    ERROR: This directory has not been set up with the EB CLI
    You must first run "eb init".


Our code is deployed using Jenkins pipelines.  The deployment process is modeled in the `Jenkinsfile`.  For every branch that is pushed to our Github, Jenkins will build, deploy the changes to staging and run the integration tests.  For the `master` branch, Jenkins will do all of the above as well as deploying to production.

The pipeline can only run for one branch at a time so that we don't have issues with staging and the integration tests.

There is currently a file called `jenkins.groovy` in addition to the `Jenkinsfile`.  `jenkins.groovy` runs the standalone jobs for deploying our code via clean-deploy.  These are left in case of emergency, but should not be necessary.

### Running Terraform

__WARNING__: Running terraform can be extremely dangerous. It is trivially easy to destroy all the AWS resources in an account, bringing down all the service environments. If you don't know what you're doing, seek help.

1. Go to rex/terraform/development (or whichever environment you want to change)
2. Run `terraform get` to pull in any terraform modules
3. Run `terraform init` to initialize the working directory
4. Run `terraform plan` to examine what changes are about to be made. Read the output careful to make sure it is correct.
5. Run `terraform apply` to make the changes.

Note: the human-readable endpoints such as rex.internal.justin.tv were manually created in Twitch's DNS tool on the dashboard, not through terraform.

### Debugging

Logs are located on the hosts at: `cd /var/log/eb-docker/containers/eb-current-app` <br>
To determine the hosts, you will need to go to the [EC2 Console](https://us-west-2.console.aws.amazon.com/ec2/v2/home?region=us-west-2#) and grab the `Private IP` Address values for the `prod-samus-rex` grouping
<br>

Quick Tip:
- pssh works best for grabbing the 70+ logs (ew that there's no log aggregation right now) - put the IP addresses (one per line) in a text file
```
pssh -O StrictHostKeyChecking=no -h ./rex_prod_ips.txt -l $USER -t 0 -p 6 -i -A 'grep "ERR" /var/log/eb-docker/containers/eb-current-app/*.log'
```

To SSH Into hosts from Amazon:
```
More info here: https://wiki.xarth.tv/display/SEC/Teleport+Bastion if the instructions below do not work 

brew install twitch-bastion-util
twitch-bastion enable
```

Then choose the IP address of the host:
```ssh <ipaddress>```


### Sample Requests

- Use [Postman](https://www.getpostman.com/) as a tool for making API calls
- Use [Insomnia](https://insomnia.rest/) as a tool for making API calls. Ask a teammate for their insomnia config for our services
- There are some sample requests in https://code.amazon.com/packages/SamusInsomniaConfiguration that can be imported into Insomnia 
