# Overview
Rex is a Twirp service that provides a set of methods for managing Twitch Prime offers.

## Offer Status
For a Twitch Prime offer, there are three possible statuses:
* **UNSEEN:** The user has not yet visualized the offer in the Twitch Prime crown.
* **SEEN:** The user has visualized the offer in the Twitch Prime crown or landing page.
* **CLAIMED:** The user has claimed the offer.
* **DISMISSED:** The user has dmismissed the offer.
* **OVERRIDDEN:** The offer should always be shown to the user.

### GetOfferStatuses
Given a Twitch user id and a list of offer ids, returns a map of offer status for each of the offers.

#### Request
**POST** /twirp/code.justin.tv.samus.rex.Rex/GetOfferStatuses

    {
        "twitchUserID": "<twitch_user_id>",
        "offerIDs": [ "<offer_id>", ... ]
    }
    
#### Response
    {
        "offerStatuses": { "<offer_id>": "SEEN" | "UNSEEN" | "CLAIMED", ... }
    }

### UpdateOfferStatuses
Given a Twitch user id and a map of offer ids to statuses, updates each offer with the mapped status and returns the updated map. Does not update offers to SEEN if they previously existed in a state other than UNSEEN.

#### Request
**POST** /twirp/code.justin.tv.samus.rex.Rex/UpdateOfferStatuses
    
    {
        "twitchUserID": "<twitch_user_id>",
         "offerStatuses": { "<offer_id>": "SEEN" | "UNSEEN" | "CLAIMED", ... }
    }
    
#### Response
    {
         "offerStatuses": { "<offer_id>": "SEEN" | "UNSEEN" | "CLAIMED", ... }
    }
