package status

import (
	"golang.org/x/net/context"

	"code.justin.tv/samus/rex/internal/clients"
	rrpc "code.justin.tv/samus/rex/rpc"
)

type OfferStatus interface {
	GetOfferStatuses(ctx context.Context, userID string, offerIDs []string) (map[string]rrpc.OfferStatus, error)
	UpdateOfferStatuses(ctx context.Context, userID string, offerStatuses map[string]rrpc.OfferStatus) error
}

type OfferStatusImpl struct {
	Clients clients.Clients
}

func NewOfferStatus(c clients.Clients) OfferStatus {
	return &OfferStatusImpl{
		Clients: c,
	}
}

// GetOfferStatuses Contains the business logic to get a user's Offer Statuses
func (s *OfferStatusImpl) GetOfferStatuses(ctx context.Context, userID string, offerIDs []string) (map[string]rrpc.OfferStatus, error) {
	statuses, err := s.Clients.StatusClient.GetOfferStatuses(ctx, userID, offerIDs)
	if err != nil {
		return make(map[string]rrpc.OfferStatus), err
	}

	return statuses, nil
}

func (s *OfferStatusImpl) UpdateOfferStatuses(ctx context.Context, userID string, offerStatuses map[string]rrpc.OfferStatus) error {
	return s.Clients.StatusClient.UpdateOfferStatuses(ctx, userID, offerStatuses)
}
