package status

import (
	"testing"

	"code.justin.tv/samus/rex/internal/clients"
	mocks "code.justin.tv/samus/rex/mocks"
	"code.justin.tv/samus/rex/rpc"
	"github.com/pkg/errors"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestGetOfferStatuses(t *testing.T) {
	Convey("TestGetOfferStatuses", t, func() {
		statusClient := new(mocks.IStatusClient)
		app := OfferStatusImpl{
			Clients: clients.Clients{StatusClient: statusClient},
		}

		Convey("Test GetOfferStatus", func() {
			Convey("When called with valid input", func() {
				userID := "123456"
				statuses := make(map[string]rex.OfferStatus)
				statuses["1"] = rex.OfferStatus_SEEN
				offerIDs := []string{"1"}

				statusClient.On("GetOfferStatuses", mock.Anything, mock.Anything, mock.Anything).Return(statuses, nil)

				result, err := app.GetOfferStatuses(nil, userID, offerIDs)
				So(err, ShouldBeNil)
				So(result, ShouldResemble, statuses)
			})

			Convey("When an error happens", func() {
				userID := "123456"
				statuses := make(map[string]rex.OfferStatus)
				statuses["1"] = rex.OfferStatus_SEEN
				offerIDs := []string{"1"}

				statusClient.On("GetOfferStatuses", mock.Anything, mock.Anything, mock.Anything).Return(statuses, errors.New("error"))

				_, err := app.GetOfferStatuses(nil, userID, offerIDs)
				So(err, ShouldNotBeNil)
			})
		})
	})
}

func TestUpdateOfferStatuses(t *testing.T) {
	Convey("TestUpdateOfferStatuses", t, func() {
		statusClient := new(mocks.IStatusClient)
		app := OfferStatusImpl{
			Clients: clients.Clients{StatusClient: statusClient},
		}

		Convey("Test UpdateOfferStatus", func() {
			Convey("When called with valid input", func() {
				userID := "123456"
				statuses := make(map[string]rex.OfferStatus)
				statuses["1"] = rex.OfferStatus_SEEN

				statusClient.On("UpdateOfferStatuses", mock.Anything, mock.Anything, mock.Anything).Return(nil)

				err := app.UpdateOfferStatuses(nil, userID, statuses)
				So(err, ShouldBeNil)
			})

			Convey("When an error happens", func() {
				userID := "123456"
				statuses := make(map[string]rex.OfferStatus)
				statuses["1"] = rex.OfferStatus_SEEN

				statusClient.On("UpdateOfferStatuses", mock.Anything, mock.Anything, mock.Anything).Return(errors.New("error"))

				err := app.UpdateOfferStatuses(nil, userID, statuses)
				So(err, ShouldNotBeNil)
			})
		})
	})
}
