package clients

import (
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/samus/gateway/client"
	"code.justin.tv/samus/rex/config"
	"code.justin.tv/samus/rex/internal/clients/gifting"
	"code.justin.tv/samus/rex/internal/clients/nitro"
	"code.justin.tv/samus/rex/internal/clients/notifications"
	"code.justin.tv/samus/rex/internal/clients/status"
	"github.com/cactus/go-statsd-client/statsd"
	"github.com/pkg/errors"
)

type Clients struct {
	StatusClient        status.IStatusClient
	GiftingClient       gifting.IGiftingClient
	NitroClient         nitro.INitroClient
	GatewayClient       samus_gateway.Client
	NotificationsClient notifications.INotificationsClient
}

// SetupClients initializes all the clients
func SetupClients(cfg *config.Configuration, stats statsd.Statter) (*Clients, error) {

	// Status
	statusClient, err := status.NewStatusClient(cfg)
	if err != nil {
		return nil, errors.Wrap(err, "Failed to create Status client")
	}

	giftingClient, err := gifting.NewGiftingClient(cfg)
	if err != nil {
		return nil, errors.Wrap(err, "Failed to create Gifting client")
	}

	gatewayClient, err := samus_gateway.NewClient(twitchclient.ClientConf{
		Host: cfg.SamusGatewayHost,
	})
	if err != nil {
		return nil, errors.Wrap(err, "Failed to create Gateway client")
	}

	notificationsClient, err := notifications.NewNotificationsClient(cfg, stats)
	if err != nil {
		return nil, errors.Wrap(err, "Failed to create Notifications client")
	}

	nitroClient, err := nitro.NewNitroClient(cfg, stats)
	if err != nil {
		return nil, errors.Wrap(err, "Failed to create Nitro client")
	}

	return &Clients{
		StatusClient:        statusClient,
		GiftingClient:       giftingClient,
		GatewayClient:       gatewayClient,
		NotificationsClient: notificationsClient,
		NitroClient:         nitroClient,
	}, nil
}
