package nitro

import (
	"context"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/samus/rex/config"

	"code.justin.tv/samus/nitro/rpc"

	"github.com/cactus/go-statsd-client/statsd"
	"github.com/pkg/errors"
)

type INitroClient interface {
	IsPrime(ctx context.Context, userID string) (bool, error)
}

type NitroClient struct {
	nitroClient nitro.Nitro
}

func (c NitroClient) IsPrime(ctx context.Context, userID string) (bool, error) {

	req := &nitro.GetPremiumStatusesRequest{
		TwitchUserID: userID,
	}

	resp, err := c.nitroClient.GetPremiumStatuses(ctx, req)
	if err != nil {
		return false, errors.Wrapf(err, "Error calling Nitro::GetPremiumStatuses for userID: %v", userID)
	}

	return resp.HasPrime, nil
}

func NewNitroClient(conf *config.Configuration, stats statsd.Statter) (*NitroClient, error) {

	nitroConf := twitchclient.ClientConf{
		Host:           conf.SamusNitroHost,
		TimingXactName: "Nitro-Client",
		Stats:          stats,
	}

	nitroClient := nitro.NewNitroProtobufClient(conf.SamusNitroHost, twitchclient.NewHTTPClient(nitroConf))

	if nitroClient == nil {
		return nil, errors.New("Failed to create nitro client")
	}

	return &NitroClient{
		nitroClient: nitroClient,
	}, nil
}
