package notifications

import (
	"reflect"
	"testing"

	"github.com/stretchr/testify/assert"

	"code.justin.tv/samus/rex/config"
)

func TestNotificationsClientConstructor(t *testing.T) {
	devConfig, err := config.LoadConfigForEnvironment("dev")
	assert.Nil(t, err, "Error loading dev config.")

	stagingConfig, err := config.LoadConfigForEnvironment("staging")
	assert.Nil(t, err, "Error loading staging config.")

	prodConfig, err := config.LoadConfigForEnvironment("prod")
	assert.Nil(t, err, "Error loading prod config.")

	devNotifClient, err := NewNotificationsClient(devConfig, nil)
	assert.Nil(t, err, "Error creating dev notif client.")

	stagingNotifClient, err := NewNotificationsClient(stagingConfig, nil)
	assert.Nil(t, err, "Error creating staging notif client.")

	prodNotifClient, err := NewNotificationsClient(prodConfig, nil)
	assert.Nil(t, err, "Error creating prod notif client.")

	devOk := (reflect.TypeOf(devNotifClient).Elem().Name() == "pushyNotificationsClient")
	assert.True(t, devOk, "Dev should have a pushy notification client.")
	stagingOk := (reflect.TypeOf(stagingNotifClient).Elem().Name() == "pushyNotificationsClient")
	assert.True(t, stagingOk, "Staging should have a pushy notification client.")
	prodOk := (reflect.TypeOf(prodNotifClient).Elem().Name() == "pushyNotificationsClient")
	assert.True(t, prodOk, "Prod should have a pushy notification client.")
}
